<?php

namespace Plugins\WidgetBuilder\Widgets;


use App\Facades\GlobalLanguage;
use Plugins\PageBuilder\Fields\Repeater;
use Plugins\PageBuilder\Helpers\RepeaterField;
use Plugins\WidgetBuilder\Traits\LanguageFallbackForWidgetBuilder;
use Plugins\WidgetBuilder\WidgetBase;


class TenantHotelBookingLinkWidget extends WidgetBase
{
    use LanguageFallbackForWidgetBuilder;
    public function admin_render()
    {
        $output = $this->admin_form_before();
        $output .= $this->admin_form_start();
        $output .= $this->default_fields();

        $widget_saved_values = $this->get_settings();

        $output .= $this->admin_language_tab_start();

        //repeater
        $output .= Repeater::get([
            'settings' => $widget_saved_values,
            'multi_lang' => true,
            'id' => 'tenant_hotel_booking_link_widget_one',
            'fields' => [
                [
                    'type' => RepeaterField::TEXT,
                    'name' => 'repeater_title',
                    'label' => __(' Link Title')
                ],
                [
                    'type' => RepeaterField::TEXT,
                    'name' => 'repeater_title_url',
                    'label' => __('Link Title URL')
                ],

            ]
        ]);


        $output .= $this->admin_language_tab_end();

        $output .= $this->admin_form_submit_button();
        $output .= $this->admin_form_end();
        $output .= $this->admin_form_after();

        return $output;
    }


    public function enable(): bool
    {
        return true; // TODO: Change the autogenerated stub
    }

    public function frontend_render()
    {
        $user_selected_language = get_user_lang();

        $repeader_data = $this->setting_item('tenant_hotel_booking_link_widget_one') ?? [];

        $link_markup = '';
        foreach ($repeader_data['repeater_title_'.$user_selected_language] ?? [] as $key =>  $item)
        {
            $repeater_title = $repeader_data['repeater_title_'.$user_selected_language][$key] ?? '';
            $repeater_title_url = $repeader_data['repeater_title_url_'.$user_selected_language][$key] ?? '';
            $link_markup.= <<<MARKUP

                <li class="footer-widget-nav-list-item">
                     <a href="{$repeater_title_url}" class="footer-widget-nav-list-link"> {$repeater_title} </a>
               </li>

            MARKUP;
        }

        return <<<HTML
        <div class="footer-widget widget">
          <div class="footer-widget-nav mt-5">
           <ul class="footer-widget-nav-list list-style-none">
               {$link_markup}
                 </ul>
            </div>
        </div>
        HTML;
    }

    public function widget_title(){
        return __('Hotel Booking links Widget');
    }

    public function columnClass(){
        return 'col-xxl-3 col-xl-3 col-lg-4 col-md-6 col-sm-8';
    }

}
