<?php

namespace Plugins\PageBuilder\Addons\Tenants\eCommerce;
use App\Facades\GlobalLanguage;
use App\Helpers\SanitizeInput;
use App\Models\FormBuilder;
use Modules\Attributes\Entities\Category;
use Modules\Blog\Entities\BlogCategory;
use Modules\Campaign\Entities\Campaign;
use Modules\Product\Entities\Product;
use Modules\Product\Entities\ProductCategory;
use Plugins\PageBuilder\Fields\Date;
use Plugins\PageBuilder\Fields\Image;
use Plugins\PageBuilder\Fields\NiceSelect;
use Plugins\PageBuilder\Fields\Number;
use Plugins\PageBuilder\Fields\Repeater;
use Plugins\PageBuilder\Fields\Select;
use Plugins\PageBuilder\Fields\Slider;
use Plugins\PageBuilder\Fields\Text;
use Plugins\PageBuilder\Fields\Textarea;
use Plugins\PageBuilder\Helpers\RepeaterField;
use Plugins\PageBuilder\PageBuilderBase;
use function __;

class ProductCampaigns extends PageBuilderBase
{

    public function preview_image()
    {
        return 'Tenant/eCommerce/product-campaigns.png';
    }

    public function admin_render()
    {
        $output = $this->admin_form_before();
        $output .= $this->admin_form_start();
        $output .= $this->default_fields();
        $widget_saved_values = $this->get_settings();

        $output .= $this->admin_language_tab();
        $output .= $this->admin_language_tab_start();
        $all_languages = GlobalLanguage::all_languages();

        foreach ($all_languages as $key => $lang) {
            $output .= $this->admin_language_tab_content_start([
                'class' => $key == 0 ? 'tab-pane fade show active' : 'tab-pane fade',
                'id' => "nav-home-" . $lang->slug
            ]);
            $output .= Text::get([
                'name' => 'title_'.$lang->slug,
                'label' => __('Title'),
                'value' => $widget_saved_values['title_'.$lang->slug] ?? null,
            ]);

            $output .= Text::get([
                'name' => 'campaign_right_title_'.$lang->slug,
                'label' => __('Right Title'),
                'value' => $widget_saved_values['campaign_right_title_'.$lang->slug] ?? null,
            ]);

            $output .= Text::get([
                'name' => 'button_text_'.$lang->slug,
                'label' => __('Button Text'),
                'value' => $widget_saved_values['button_text_'.$lang->slug] ?? null,
            ]);
            $output .= $this->admin_language_tab_content_end();
        }
        $output .= $this->admin_language_tab_end(); //have to end language tab

        $categories = Campaign::select('id','title')->where(['status' => 'publish'])->get()->pluck('title','id');

        $output .= Select::get([
            'name' => 'campaign_id',
            'label' => __('Select Campaign'),
            'placeholder' => __('Select Campaign'),
            'options' => $categories,
            'value' => $widget_saved_values['campaign_id'] ?? null,
            'info' => __('you can select your desired products or leave it empty')
        ]);


        // add padding option
        $output .= $this->padding_fields($widget_saved_values);
        $output .= $this->admin_form_submit_button();
        $output .= $this->admin_form_end();
        $output .= $this->admin_form_after();

        return $output;
    }

    public function frontend_render()
    {
        $lang = get_user_lang();
        $padding_top = SanitizeInput::esc_html($this->setting_item('padding_top'));
        $padding_bottom = SanitizeInput::esc_html($this->setting_item('padding_bottom'));
        $title = SanitizeInput::esc_html($this->setting_item('title_'.$lang) ?? '');
        $campaign_id = SanitizeInput::esc_html($this->setting_item('campaign_id') ?? '');

        $button_text = SanitizeInput::esc_html($this->setting_item('button_text_'.$lang) ?? '');
        $campaign_right_title = SanitizeInput::esc_html($this->setting_item('campaign_right_title_'.$lang) ?? '');

        $campaign = Campaign::with('products','products.product')->where(['status' => 'publish'])->where('id',$campaign_id)->first();

        $products = $campaign?->products;

        $data = [
            'padding_top'=> $padding_top,
            'padding_bottom'=> $padding_bottom,
            'title' => $title,
            'button_text' => $button_text,
            'campaign_right_title' => $campaign_right_title,
            'products'=> $products,
            'campaign'=> $campaign,
        ];


        return self::renderView('tenant.eCommerce.product-campaigns',$data);
    }

    public function enable(): bool
    {
        return !is_null(tenant());
    }

    public function addon_title()
    {
        return __('Product Campaigns');
    }
}
