<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateWalletHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('wallet_histories', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('user_id');
            $table->string('payment_gateway')->nullable();
            $table->string('payment_status')->nullable();
            $table->double('amount')->default(0);
            $table->string('transaction_id')->nullable();
            $table->string('manual_payment_image')->default(0);
            $table->tinyInteger('status')->default(1);

            $table->index(['user_id']);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('wallet_histories');
    }
}
